function CurvePlot(CompareMatrix, YCoor)

colorVector = [
               [255 127 0]/255;
               [127 127 127]/255; 
               [127 0 127]/255; 
               [0 0 255]/255;
               [0 255 127]/255;
               [255 0 127]/255;
              ];
width = 3;
[Num, Length]= size(CompareMatrix);
Coor = 1 : Length;
aix = [1, Length, 0.99*min(CompareMatrix(:)), 1.01*max(CompareMatrix(:))];
h = figure(1);
set(gca,'FontSize',20); 
for ii= 1:Num
    plot(Coor, CompareMatrix(ii,:), 'LineWidth',width, 'color',colorVector(ii,:));
    axis(aix);
    xlabel('thresholds','fontsize',25);
    ylabel(YCoor,'fontsize',25);
    hold on; 
end

hl = legend('Lu2014', 'Lu2012', 'CIE Y', ' Grundland07', 'Smith08', 'Gooch05', 'Location','northeast');
set(hl,'Fontsize',12);
 
end